<?php

require_once get_template_directory() . '/inc/theme-setup.php';
/*
 * call the framework
 *
 */
require get_template_directory() . '/inc/autoload.php';


// Handle AJAX request to add product to WooCommerce cart
add_action('wp_ajax_add_product_to_cart', 'add_product_to_cart');
add_action('wp_ajax_nopriv_add_product_to_cart', 'add_product_to_cart');
function add_product_to_cart() {
    if (isset($_POST['plan_id'])) {
        $plan_id = intval($_POST['plan_id']);
        // Assuming $product_id is related to the plan
        $product_id = $plan_id; // Replace with the actual product ID you want to add to cart
        $price = get_post_meta($plan_id, '_price', true); // Get price of the selected plan
        // Add the product to the cart
        WC()->cart->add_to_cart($product_id, 1, '', '', [
            'request_user_id' => get_current_user_id(),
            'price' => $price
        ]);
        // Send success response
        wp_send_json_success();
    } else {
        // Send failure response if no plan_id is provided
        wp_send_json_error();
    }
}